/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.modemcfg;

import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigConstants;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigData;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigEvent;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigListener;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ModemConfigManager
implements ModemConfigConstants {
    private static final String TRACE_MASKT = "XRCSMCMT";
    private static final String TRACE_MASKF = "XRCSMCMF";
    private static final String TRACE_MASKD = "XRCSMCMD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-MdCfgMgr");
    private static final String PERSISTENCE_NAME = "com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigData";
    private static ModemConfigManager modemConfigMgr = null;
    private Object dataLock = new Object();
    private List listeners = new ArrayList();
    private Object listenersLock = new Object();

    private ModemConfigManager() {
        Trace.trace(TRACE_MASKT, "<> ModemConfigManager()");
    }

    public static synchronized ModemConfigManager getModemConfigManager() {
        Trace.trace(TRACE_MASKT, "-> getModemConfigManager()");
        if (modemConfigMgr == null) {
            modemConfigMgr = new ModemConfigManager();
        }
        Trace.trace(TRACE_MASKT, "<- getModemConfigManager()");
        return modemConfigMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModemConfigListener(ModemConfigListener listener) {
        Trace.trace(TRACE_MASKT, "-> addModemConfigListener()");
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
        Trace.trace(TRACE_MASKT, "<- addModemConfigListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModemConfigListener(ModemConfigListener listener) {
        Trace.trace(TRACE_MASKT, "-> removeModemConfigListener()");
        Object object = this.listenersLock;
        synchronized (object) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
        Trace.trace(TRACE_MASKT, "<- removeModemConfigListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModemConfigData getModemConfig() {
        Trace.trace(TRACE_MASKT, "-> getModemConfig()");
        ModemConfigData modemConfigData = null;
        Object object = this.dataLock;
        synchronized (object) {
            PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
            if (persMgr.contains(PERSISTENCE_NAME)) {
                try {
                    modemConfigData = (ModemConfigData)persMgr.read(PERSISTENCE_NAME);
                }
                catch (PersistenceException pe) {
                    new FrameworkLog(classLogInfo, 1938, pe).log();
                    modemConfigData = new ModemConfigData();
                }
            } else {
                modemConfigData = new ModemConfigData();
            }
        }
        Trace.trace(TRACE_MASKT, "<- getModemConfig()");
        return modemConfigData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModemConfig(ModemConfigData data) {
        DataRepApp dataRepApp;
        Trace.trace(TRACE_MASKT, "-> setModemConfig()");
        Trace.trace(TRACE_MASKF, data.toString());
        boolean replicateData = false;
        Object object = this.dataLock;
        synchronized (object) {
            try {
                PersistenceManager.getPersistenceManager().write(PERSISTENCE_NAME, data);
                Object object2 = this.listenersLock;
                synchronized (object2) {
                    if (this.listeners.size() > 0) {
                        ModemConfigData dataCopy = this.getModemConfig();
                        ModemConfigEvent event = new ModemConfigEvent(this, 1, dataCopy);
                        Iterator iterator = this.listeners.iterator();
                        while (iterator.hasNext()) {
                            ModemConfigListener listener = (ModemConfigListener)iterator.next();
                            String className = listener.getClass().getName();
                            Trace.trace(TRACE_MASKF, "-> " + className + ".modemConfigChanged()");
                            listener.modemConfigChanged(event);
                            Trace.trace(TRACE_MASKF, "<- " + className + ".modemConfigChanged()");
                        }
                    }
                }
                replicateData = true;
            }
            catch (PersistenceException pe) {
                Trace.trace(TRACE_MASKF, "PersistenceException: " + pe.getMessage());
                new FrameworkLog(classLogInfo, 1938, pe).log();
            }
        }
        if (replicateData && (dataRepApp = DataRepApp.getDataRepApp()).isDataRepEnabled() && !dataRepApp.isUpdateInProgress()) {
            dataRepApp.updateCustomDataLevel(PERSISTENCE_NAME);
        }
        Trace.trace(TRACE_MASKT, "<- setModemConfig()");
    }

    public static class SaveRestore
    implements CustomizableData {
        public SaveRestore() {
            Trace.trace(ModemConfigManager.TRACE_MASKT, "<> SaveRestore");
        }

        public UIInfo getUIInfo() {
            LocalizableText name = new LocalizableText("com.ibm.hwmca.fw.rcs.modemcfg.res.ModemConfigMsgs", "DATA_NAME");
            LocalizableText caption = new LocalizableText("com.ibm.hwmca.fw.rcs.modemcfg.res.ModemConfigMsgs", "DATA_CAPTION");
            return new UIInfo(name, caption);
        }

        public Serializable getSaveableData() {
            Trace.trace(ModemConfigManager.TRACE_MASKT, "-> getSaveableData()");
            ModemConfigManager cfgMgr = ModemConfigManager.getModemConfigManager();
            ModemConfigData modemConfigData = cfgMgr.getModemConfig();
            Trace.trace(ModemConfigManager.TRACE_MASKF, modemConfigData.toString());
            Trace.trace(ModemConfigManager.TRACE_MASKT, "<- getSaveableData()");
            return modemConfigData.getPersistentData();
        }

        public void restoreData(Serializable obj) {
            Trace.trace(ModemConfigManager.TRACE_MASKT, "-> restoreData()");
            try {
                PersistentData persistentData = (PersistentData)obj;
                ModemConfigData modemConfigData = new ModemConfigData(persistentData);
                ModemConfigManager cfgMgr = ModemConfigManager.getModemConfigManager();
                cfgMgr.setModemConfig(modemConfigData);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Trace.trace(ModemConfigManager.TRACE_MASKT, "<- restoreData()");
        }

        public String getCustomDataKey() {
            return ModemConfigManager.PERSISTENCE_NAME;
        }
    }
}

